/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssValueList;

public class CssTextUnderlinePosition
extends org.w3c.css.properties.css.CssTextUnderlinePosition {
    public static final CssIdent auto;
    public static final CssIdent[] horizontalValues;
    public static final CssIdent[] verticalValues;

    public static CssIdent getHorizontalValue(CssIdent ident) {
        for (CssIdent id : horizontalValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static CssIdent getVerticalValue(CssIdent ident) {
        for (CssIdent id : verticalValues) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public static final CssIdent getAllowedValue(CssIdent ident) {
        if (auto.equals(ident)) {
            return auto;
        }
        CssIdent id = CssTextUnderlinePosition.getHorizontalValue(ident);
        if (id != null) {
            return id;
        }
        return CssTextUnderlinePosition.getVerticalValue(ident);
    }

    public CssTextUnderlinePosition() {
        this.value = initial;
    }

    public CssTextUnderlinePosition(ApplContext ac, CssExpression expression, boolean check2) throws InvalidParamException {
        if (check2 && expression.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        this.setByUser();
        CssValue horValue = null;
        CssValue verValue = null;
        CssValue val = expression.getValue();
        char op = expression.getOperator();
        if (val.getType() != 0) {
            throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
        }
        CssIdent ident = val.getIdent();
        if (CssIdent.isCssWide(ident)) {
            this.value = val;
            if (check2 && expression.getCount() != 1) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        } else if (auto.equals(ident)) {
            this.value = val;
            if (check2 && expression.getCount() != 1) {
                throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
            }
        } else {
            int nbgot = 0;
            do {
                boolean match = false;
                if (verValue == null) {
                    boolean bl = match = CssTextUnderlinePosition.getVerticalValue(ident) != null;
                    if (match) {
                        verValue = val;
                    }
                }
                if (!match && horValue == null) {
                    boolean bl = match = CssTextUnderlinePosition.getHorizontalValue(ident) != null;
                    if (match) {
                        horValue = val;
                    }
                }
                if (!match) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                if (expression.getRemainingCount() == 1 || !check2 && ++nbgot == 2) break;
                if (op != ' ') {
                    throw new InvalidParamException("operator", Character.toString(op), ac);
                }
                expression.next();
                val = expression.getValue();
                op = expression.getOperator();
                if (val.getType() != 0) {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
                ident = val.getIdent();
            } while (!expression.end());
            ArrayList<CssValue> v = new ArrayList<CssValue>(nbgot);
            if (horValue != null) {
                v.add(horValue);
            }
            if (verValue != null) {
                v.add(verValue);
            }
            this.value = nbgot > 1 ? new CssValueList(v) : (CssValue)v.get(0);
        }
        expression.next();
    }

    public CssTextUnderlinePosition(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    static {
        String[] _horizontalValues = new String[]{"left", "right"};
        horizontalValues = new CssIdent[_horizontalValues.length];
        int i = 0;
        for (String s : _horizontalValues) {
            CssTextUnderlinePosition.horizontalValues[i++] = CssIdent.getIdent(s);
        }
        String[] _verticalValues = new String[]{"under", "from-font"};
        verticalValues = new CssIdent[_verticalValues.length];
        i = 0;
        for (String s : _verticalValues) {
            CssTextUnderlinePosition.verticalValues[i++] = CssIdent.getIdent(s);
        }
        auto = CssIdent.getIdent("auto");
    }
}

